#pragma once

#include "MagAPI.h"

// CMainSheet

class CMainSheet : public CPropertySheet
{
	DECLARE_DYNAMIC(CMainSheet)

#ifdef _M_X64
  #define MSGBOX_TITLE _T("Ultima SDK C++ Demo - SDK 64")
#else
  #define MSGBOX_TITLE _T("Ultima SDK C++ Demo - SDK 32")
#endif
#define FUNCTION_NOT_ACCESSED(x)  MessageBox(_T(#x) _T(": Function entry point not found"), MSGBOX_TITLE, MB_OK | MB_ICONSTOP)
#define DISPLAY_ERROR(x, y) CString zzz = _T(#x);			\
							zzz += _T(": ") + Parent->HandleError(y);	\
							MessageBox(zzz, MSGBOX_TITLE, MB_OK | MB_ICONSTOP)

#define MAX_CARD_WIDTH     1036
#define MAX_CARD_HEIGHT    664


public:
	CMainSheet(UINT nIDCaption, CWnd* pParentWnd = NULL, UINT iSelectPage = 0);
	CMainSheet(LPCTSTR pszCaption, CWnd* pParentWnd = NULL, UINT iSelectPage = 0);
	virtual ~CMainSheet();
	virtual BOOL OnInitDialog();
	virtual BOOL OnNcCreate(LPCREATESTRUCT lpCreateStruct);
	int MaxCardWidth();
	int MaxCardHeight();
	int MaxXCoord();
	int MaxYCoord();
	void AddString(CEdit *pControl, CString str);
	CString Separator(ID_READWRITE Action);
	CString CorrectionString(int Correction);
	CString OnOffString(int State);
	CString SideString(int Side);
	CString EnabledDisabledString(BOOL State);
	CString HandleError(int Error);
	ID_RETURN WaitForPrinterToFinish();
	ID_RETURN WaitForPrinterToPrint();

	HANDLE     hSession;
	HINSTANCE  hLib;

	BOOL       PrintToFile;

protected:
	DECLARE_MESSAGE_MAP()
};
